#include "PyramidMesh.h"


graphics::PyramidMesh::PyramidMesh()
{
	static const int NUM_VERTICES = 5;
	/* 
	 first 5 vertices
	 next 5 normals
	*/
	static const GLfloat vectors[] = {
		-1.0f, -1.0f, -1.0f,
		1.0f, -1.0f, -1.0f,
		1.0f, -1.0f, 1.0f,
		-1.0f, -1.0f, 1.0f,
		0.0f, 1.0f, 0.0f
	};
	/*
		first 6 are the indices 
	*/
	static const int indices[] = {
		0,1,2,
		0,2,3,
		0,1,4,
		1,2,4,
		2,3,4,
		3,1,4
	};

	/* create vertex array obj  and bind */
	glGenVertexArrays(1, &m_VAO);
	glBindVertexArray(m_VAO);

	/* generate buffers*/
	glGenBuffers(2, &m_buffers[0]);

	/* store vertex data */
	glBindBuffer(GL_ARRAY_BUFFER, m_buffers[0]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(vectors), &vectors[0], GL_STATIC_DRAW);
	
	/* describe vertex buffer */
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(0);

	/* store index data*/
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, m_buffers[1]);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(indices), &indices[0], GL_STATIC_DRAW);

	/* unbind */
	glBindVertexArray(0);
}


graphics::PyramidMesh::~PyramidMesh()
{
	glDeleteBuffers(2, &m_buffers[0]);
	glDeleteVertexArrays(1, &m_VAO);
}

void graphics::PyramidMesh::render() {
	
	glBindVertexArray(m_VAO);

	glDrawElements(GL_TRIANGLES, 18, GL_UNSIGNED_INT, 0);

	glBindVertexArray(0);
	
}